# Début programme de lecture Télémètre Ultrason (Graphique)
# Ce programme mesure le télémètre ultrason et affiche la distance dans un graphique.

# S'utiliser avec :
# - Sciencethic 651 049 - Télémètre Ultrason fixe
# - Grove - Ultrasonic Ranger 101020010

# Le fichier libFenetreGraphiqueTempsReel.py fournit la classe GraphiqueTempsReel.
# GraphiqueTempsReel offre un graphique temps réel a 1 ou deux voies.
# Le fichier libFenetreGraphiqueTempsReel.py doit etre dans le meme répertoire que ce programme.
from libFenetreGraphiqueTempsReel import GraphiqueTempsReel         

# Nous instancions un objet fenetre utilisant la classe "GraphiqueTempsReel".
# Les parametres principaux de la fenetre sont définit par le constructeur.
fenetre = GraphiqueTempsReel(
    nomFenetre="Plug'Uno - acquisition",
    titreFigure="Mesure distance Télémètre Ultrason",
    legendeAxeX="(index échantillon)",
    legendeAxeY="(distance cm)",
    legendeVoie1="Télémètre sur D2",
    nombrePointSurX=100,
    yMin = 0,
    yMax = 150 # distance max affichable définit a 150 cm
)

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-série Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Active le mécanisme de récuperation des différents états des E/S de Plug'Uno ;
# Définit la fréquence d'échantillonnage maximum.
plugUno.samplingOn( 20 ) # 20 ms min -> 50 Hz max

################################
# Configuration des E/S
################################
brocheTelemetre = plugUno.get_pin('d:2:u')
# -> d : signifie mode tout-ou-rien/digital
# -> u : numéro de la broche, seul 2/3 sont compatible
# -> u : mode télémètre ultrason

# Conversion expliqué interval de temps vers distance
# Retourn une distance en metre
def convertirIntervalTempsEnDistance(tempsAlleEtRetour):    
    # distance = vitesseDuSon * temps
    vitesseDuSon = 331 # m/s
    distanceEnMetre = vitesseDuSon * ( tempsAlleEtRetour / 2 ) * 1E-6
    return distanceEnMetre

# Définit la fonction qui sera appelé a chaque mesure d'interval de temps télémètre
def fonctionDeRappelLectureTelemetre(tempsAllerEtRetour):
    # variable tempsAlleRetour : temps en microseconde
    fenetre.ajouterDonnee( convertirIntervalTempsEnDistance( tempsAllerEtRetour ) * 1E2 )
    # -> méthode d'ajout de donné a la volé de la classe GraphiqueTempsReel

# Associe la fonction de rappel définie ci-dessus a l'énement de mise a jour mesure d'interval de temps télémètre
brocheTelemetre.register_callback(fonctionDeRappelLectureTelemetre)

# Affiche la fenêtre de tracé de graphique
fenetre.afficher()
# -> méthode dite "blocante".
# Le programme franchira cette instruction quand la fenetre de trace sera fermé.

# Fermer la connexion à Plug'Uno avant de quitter.
plugUno.exit()

# Termine l'éxecution du programme Python.
#exit()

# Fin programme de lecture Télémètre Ultrason (Graphique)
